unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdTCPConnection, IdTCPClient, IdBaseComponent, IdComponent,
  IdTCPServer, Borland.Vcl.StdCtrls, System.ComponentModel,IdContext;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    IdTCPServer1: TIdTCPServer;
    IdTCPClient1: TIdTCPClient;
    Edit3: TEdit;
    GroupBox1: TGroupBox;
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure IdTCPServer1Disconnect(AContext: TIdContext);
    procedure IdTCPServer1Execute(AContext: TIdContext);
    procedure IdTCPServer1Connect(AContext: TIdContext);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure WyslijWiadomosc(TCPKlient: TidTCPClient; kto, tekst: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.WyslijWiadomosc(TCPKlient: TidTCPClient; kto, tekst: String);
begin
if TCPKlient.Connected then
begin
ListBox2.Items.Add(kto+': '+tekst);
TCPKlient.Socket.WriteLn(tekst);
end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
if ListBox1.ItemIndex<0 then
  begin
  ShowMessage('Nie zaznaczona adnego adresu!');
  exit;
  end;
try
idTCPClient1.Host:=ListBox1.Items[ListBox1.ItemIndex];
idTCPClient1.Connect;
ListBox2.Items.Add('Poczono z '+idTCPClient1.Host);
except on E:Exception do
 ShowMessage(E.Message);
end;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
WyslijWiadomosc(idTCPClient1,Edit3.Text,Edit1.Text);
Edit1.Clear;

end;

procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key=13 then
begin
WyslijWiadomosc(idTCPClient1,Edit3.Text,Edit1.Text);
Edit1.Clear;
end;

end;

procedure TForm1.IdTCPServer1Connect(AContext: TIdContext);
begin
if IdTCPClient1.Connected=false then
begin
try
idTCPClient1.Host:=AContext.Connection.Socket.Binding.PeerIP;
idTCPClient1.Connect;
ListBox2.Items.Add('[Poczenie od '+AContext.Connection.Socket.Binding.PeerIP+']');
except on E:Exception do
 ShowMessage(E.Message);
end;
end;

end;

procedure TForm1.IdTCPServer1Execute(AContext: TIdContext);
var wiadomosc: string;
begin
wiadomosc:=AContext.Connection.Socket.ReadLn;
if wiadomosc='!!!close' then
idTCPClient1.Disconnect
else
ListBox2.Items.Add('('+AContext.Connection.Socket.Binding.PeerIP+') '+wiadomosc);
end;

procedure TForm1.IdTCPServer1Disconnect(AContext: TIdContext);
begin
ListBox2.Items.Add('[Poczenie przerwane]');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if idTCPClient1.Connected then
begin
idTCPClient1.Socket.WriteLn('!!!close');
idTCPClient1.Disconnect;
end;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
ListBox1.Items.SaveToFile('kontakty.txt');
if idTCPClient1.Connected then
begin
idTCPClient1.Socket.WriteLn('!!!close');
idTCPServer1.Free;
idTCPClient1.Free;
end;

end;

procedure TForm1.Button4Click(Sender: TObject);
begin
ListBox1.Items.Add(Edit2.Text);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
if FileExists('kontakty.txt') then
ListBox1.Items.LoadFromFile('kontakty.txt');

end;

end.
